import { BrowserRouter as Router, Route, Routes } from 'react-router-dom';
import Customers from './components/Customers';
import Layout from "./components/Layout";
import React, {useEffect, useState} from 'react';
import CustomerFormContainer from "./components/CustomerFormContainer";
import CustomerDetails from "./components/CustomerDetails";
import ErrorPage from "./components/ErrorPage";
import Restaurants from "./components/Restaurants";
import Reservations from "./components/Reservations";
import RestaurantDetails from "./components/RestaurantDetails";
import ReservationConfirmation from "./components/ReservationConfirmation";
import ReservationEdit from "./components/ReservationEdit";
import axios from "axios";

const App = () => {
    return (
        <Router>
            <Layout>
                <Routes>
                    <Route path="/" element={<Home />} />
                    <Route path="/customers" element={<Customers />} />
                    <Route path="/customers/add" element={<CustomerFormContainer/>} />
                    <Route path="/customers/:id" element={<CustomerDetails />} />
                    <Route path="/customers/edit/:id" element={<CustomerFormContainer/>} />
                    <Route path="/restaurants" element={<Restaurants />} />
                    <Route path="/restaurants/:id" element={<RestaurantDetails />} />
                    <Route path="/reservations" element={<Reservations />} />
                    <Route path="/reservationConfirmation/:tableNumber/:timeSlot/:restaurantId" element={<ReservationConfirmation />} />
                    <Route path="/reservations/reservationEdit/:reservationId" element={<ReservationEdit />} />
                    <Route path="/error" element={<ErrorPage/>}/>
                </Routes>
            </Layout>
        </Router>
    );
}


const Home = () => {
    const todayDate = new Date().toISOString().split('T')[0]; // Get today's date in 'YYYY-MM-DD' format

    const [date, setDate] = useState(todayDate);
    const [selectedTime, setSelectedTime] = useState('');
    const [numPeople, setNumPeople] = useState(2);
    const [searchValue, setSearchValue] = useState('');
    const [timeSlots, setTimeSlots] = useState([]);

    useEffect(() => {
        if (date) {
            const selectedDate = new Date(date);
            const today = new Date();
            const isToday = selectedDate.toDateString() === today.toDateString();

            // Determine the start hour and minute
            let startHour = 9;
            let startMinute = 0;
            if (isToday) {
                const currentHour = today.getHours();
                const currentMinute = today.getMinutes();
                // If current time is later than 09:00, start from the current hour and minute
                if (currentHour > 9 || (currentHour === 9 && currentMinute >= 0)) {
                    startHour = currentHour;
                    startMinute = Math.ceil(currentMinute / 15) * 15;
                }
            }

            // Create the start time and end time
            const startTime = new Date(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate(), startHour, startMinute);
            const endTime = new Date(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate(), 23, 30);

            // Generate time slots from start time to end time in 15-minute intervals
            const slots = [];
            let currentTime = new Date(startTime);
            while (currentTime <= endTime) {
                const option = currentTime.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: false });
                slots.push(option);
                currentTime.setMinutes(currentTime.getMinutes() + 15); // Increment by 15 minutes
            }

            // Update the timeSlots state
            setTimeSlots(slots);
        }
    }, [date]);


    const handleDateChange = (e) => {
        setDate(e.target.value);
    };

    const handleTimeChange = (e) => {
        setSelectedTime(e.target.value);
    };

    const handleNumPeopleChange = (e) => {
        setNumPeople(e.target.value);
    };

    const handleInputChange = (event) => {
        setSearchValue(event.target.value);
    };

    const handleSubmit = async (e) => {
        e.preventDefault();
        const [year, month, day] = date.split("-");

        let formattedDateTime;
        const [selectedHours, selectedMinutes] = selectedTime.split(":");
        // Check if selectedHours and selectedMinutes are valid numbers
        if (!isNaN(selectedHours) && !isNaN(selectedMinutes)) {
            const dateTime = new Date(Date.UTC(year, month - 1, day, selectedHours, selectedMinutes));
            formattedDateTime = dateTime.toISOString().slice(0, 16).replace('T', ' ');
        } else {
            // Default values if selectedTime is not valid
            const now = new Date();
            let defaultTime;
            if (now.getHours() >= 9 && now.getHours() <= 23) {
                defaultTime = now;
            } else {
                defaultTime = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 9, 0); // Set to 09:00 if current time is before 09:00
            }
            const dateTime = new Date(Date.UTC(year, month - 1, day, defaultTime.getHours(), defaultTime.getMinutes()));
            formattedDateTime = dateTime.toISOString().slice(0, 16).replace('T', ' ');
        }

        const data = {
            dateTime: formattedDateTime,
            partySize: numPeople,
            search: searchValue
        };

        console.log("pecatam data pod mene")
        console.log(data)

        try {
            const response = await axios.post('http://localhost:8080/api/search', data);
            const filteredRestaurants = response.data;
            console.log(filteredRestaurants);
            // Handle response accordingly
        } catch (error) {
            console.error('Error:', error);
        }
    };



// Rest of your component code...

    const today = new Date();
    const year = today.getFullYear();
    const month = String(today.getMonth() + 1).padStart(2, '0');
    const day = String(today.getDate()).padStart(2, '0');
    const formattedDate = `${year}-${month}-${day}`;


    return (
        <div className="container">
            <h2>Home</h2>
            <p>Welcome to My Awesome App!</p>
            <form className="row g-2 align-items-center" onSubmit={handleSubmit}>
                <div className="col-auto">
                    <input className="form-control me-2" type="date" value={date} onChange={handleDateChange}
                           min={formattedDate}/>
                </div>
                <div className="col-auto">
                    <select className="form-select" onChange={handleTimeChange}>
                        {timeSlots.map((slot, index) => (
                            <option key={index} value={slot}>{slot}</option>
                        ))}
                    </select>
                </div>
                <div className="col-auto">
                    <select className="form-select" value={numPeople} onChange={handleNumPeopleChange}>
                        {[...Array(20).keys()].map((num) => (
                            <option key={num + 1} value={num + 1}>{num + 1}</option>
                        ))}
                    </select>
                </div>
                <div className="col-auto">
                    <input
                        className="form-control me-2"
                        type="search"
                        name="search"
                        placeholder="Restaurant or Cuisine"
                        aria-label="Search"
                        value={searchValue} // Set the value of the input field
                        onChange={handleInputChange} // Call the event handler on change
                    />
                </div>
                <div className="col-auto">
                    <button className="btn btn-outline-success" type="submit">Search</button>
                </div>
            </form>
        </div>
    );
}


export default App;
