package com.example.rezevirajmasa.demo.web.rest;

import com.example.rezevirajmasa.demo.model.*;
import com.example.rezevirajmasa.demo.service.CustomerService;
import com.example.rezevirajmasa.demo.service.ReservationService;
import com.example.rezevirajmasa.demo.service.RestaurantService;
import com.example.rezevirajmasa.demo.service.TableService;
import jdk.jfr.consumer.RecordingStream;
import org.apache.coyote.Response;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

@CrossOrigin(origins = "http://localhost:3000/")
@RestController
public class testController {
    private final RestaurantService restaurantService;
    private final CustomerService customerService;
    private final ReservationService reservationService;
    private final TableService tableService;

    public testController(RestaurantService restaurantService, CustomerService customerService, ReservationService reservationService, TableService tableService) {
        this.restaurantService = restaurantService;
        this.customerService = customerService;
        this.reservationService = reservationService;
        this.tableService = tableService;
    }

    @GetMapping("/api/memberships")
    public ResponseEntity<List<MembershipLevel>> getMemeberships() {
        return new ResponseEntity<List<MembershipLevel>>(List.of(MembershipLevel.values()), HttpStatus.OK);
    }

    //restaurants

    @RequestMapping("/api/restaurants")
    public ResponseEntity<List<Restaurant>> getAllRestaurants() {
        return new ResponseEntity<List<Restaurant>>(restaurantService.listall(), HttpStatus.OK);
    }

    @RequestMapping("/api/restaurants/{restaurantId}")
    public ResponseEntity<Restaurant> getRestaurantById(@PathVariable Long restaurantId) {
        return new ResponseEntity<Restaurant>(restaurantService.findById(restaurantId), HttpStatus.OK);
    }

    @PostMapping("/api/search")
    public ResponseEntity<List<Restaurant>> searchRestaurants(@RequestBody Map<String, Object> requestData) {
        String dateTime = (String) requestData.get("dateTime");
        Integer partySize = (Integer) requestData.get("partySize");
        String search = (String) requestData.get("search");

        // Now proceed with parsing dateTime and performing the search based on the received parameters

        LocalDateTime parsedDateTime = null;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        if (dateTime != null) {
            parsedDateTime = LocalDateTime.parse(dateTime, formatter);
        }

        List<Restaurant> filteredRestaurants = restaurantService.findRestaurantsByDateTimeAndPartySize(parsedDateTime, partySize, search);

        return new ResponseEntity<List<Restaurant>>(filteredRestaurants, HttpStatus.OK);
    }

//    Customer CALLS

    @RequestMapping("/api/customers")
    public ResponseEntity<List<Customer>> getAllCustomers() {
        return new ResponseEntity<List<Customer>>(customerService.listAll(), HttpStatus.OK);
    }

    @RequestMapping("/api/customers/{id}")
    public ResponseEntity<Customer> getCustomerById(@PathVariable Long id) {
        return new ResponseEntity<Customer>(customerService.findById(id), HttpStatus.OK);
    }

    @PutMapping("/api/customers/edit/{id}")
    public ResponseEntity<Customer> editCustomerById(@PathVariable Long id, @RequestBody Customer customer) {
        return new ResponseEntity<Customer>(
                customerService.updateCustomer(id, customer.getFirstName(), customer.getLastName(), customer.getEmail(), customer.getPassword(), customer.getPhone(), customer.getAddress(), customer.getMembershipLevel()),
                HttpStatus.OK
        );
    }

    @PostMapping("/api/customers")
    public ResponseEntity<Customer> saveCustomer(@RequestBody Customer customer) {
        // Ensure that the role is set to ROLE_USER by default
        customer.setRole(Role.ROLE_USER);
        return new ResponseEntity<Customer>(
                customerService.registration(customer),
                HttpStatus.OK
        );
    }

    @DeleteMapping("/api/customers/delete/{customerId}")
    public ResponseEntity<Response> deleteCustomer(@PathVariable Long customerId) {
        boolean deleted = customerService.deleteById(customerId);
        if(deleted) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.notFound().build();
        }
    }

//    Reservation Calls

    @GetMapping("/api/reservations")
    public ResponseEntity<List<Reservation>> getReservations() {
        return new ResponseEntity<List<Reservation>>(reservationService.listAll(), HttpStatus.OK);
    }

    @PostMapping("/api/reservations")
    public ResponseEntity<Reservation> createReservation(@RequestBody Reservation reservation) {
        reservation.setReservationDateTime(LocalDateTime.now());
        Reservation savedReservation = reservationService.makeReservationRest(reservation);
        return new ResponseEntity<>(savedReservation, HttpStatus.CREATED);
    }

    @GetMapping("/api/reservations/{reservationId}")
    public ResponseEntity<Reservation> getReservation(@PathVariable Long reservationId) {
        Reservation reservation = reservationService.findById(reservationId);
        if (reservation != null) {
            return ResponseEntity.ok(reservation);
        } else {
            return ResponseEntity.notFound().build();
        }
    }

    @PostMapping("/api/reservations/{reservationId}")
    public ResponseEntity<Reservation> editReservation(@PathVariable Long reservationId,
                                                       @RequestBody Reservation reservation) {
        if (!reservation.getReservationID().equals(reservationId)) {
            return ResponseEntity.badRequest().build();
        }

        Reservation savedReservation = reservationService.findById(reservationId);
        if(!reservation.getCheckInTime().equals(savedReservation.getCheckInTime())) {
            tableService.canceledTimeSlots(savedReservation.getTable().getId(), savedReservation.getCheckInTime());
        }

        savedReservation.setReservationDateTime(LocalDateTime.now());
        savedReservation.setCheckInTime(reservation.getCheckInTime());
        savedReservation.setCheckOutTime(reservation.getCheckInTime().plusHours(2));
        savedReservation.setPartySize(reservation.getPartySize());
        savedReservation.setSpecialRequests(reservation.getSpecialRequests());
        tableService.deleteTimeSlotsForReservation(reservation.getTable().getId(), reservation.getCheckInTime());

        //moze da se vovede sistem za ako od 4ca doagjaat samo 2ca da se najde pomala masa po moznost ako ima u toj moment
        //listaj samo slotovi za taa masa vo toj moment ili da ima da odbere od novo ama taka bolje nova rezevacij

        Reservation updatedReservation = reservationService.makeReservationRest(savedReservation);
        System.out.println("Saved reservation time: " + savedReservation.getCheckInTime());
        return ResponseEntity.ok(updatedReservation);
    }

    @DeleteMapping("/api/reservations/delete/{reservationId}")
    public ResponseEntity<Response> deleteReservation(@PathVariable Long reservationId) {
        boolean deleted = reservationService.cancelReservation(reservationId);
        if(deleted) {
            return ResponseEntity.ok().build();
        } else {
            return ResponseEntity.notFound().build();
        }
    }

//    TableEntity Calls

    @GetMapping("/api/tables/{tableId}")
    public ResponseEntity<TableEntity> findTableById(@PathVariable Long tableId) {
        return new ResponseEntity<TableEntity>(tableService.findById(tableId), HttpStatus.OK);
    }

}
