package com.example.rezevirajmasa.demo.service;

import ch.qos.logback.core.net.server.Client;
import com.example.rezevirajmasa.demo.dto.CustomerDTO;
import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.model.MembershipLevel;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Role;

import java.util.Date;
import java.util.List;


public interface CustomerService {
    Customer registration(String firstName, String lastName, String email, String password, String phone, String address, MembershipLevel membershipLevel, Role role);
    List<Customer> listAll();
    Customer findByEmail(String email);
    Customer findById(Long id);
    Customer updateCustomer(Long id, String firstName, String lastName, String email, String password, String phone, String address, MembershipLevel membershipLevel);
    Customer registration(Customer customer);
    boolean deleteById(Long customerId);
    public CustomerDTO mapCustomerToDTO(Customer customer);
}
