package com.example.rezevirajmasa.demo.repository;

import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.time.LocalDateTime;
import java.util.List;

public interface TableRepository extends JpaRepository<TableEntity, Long> {
    List<TableEntity> findByRestaurant(Restaurant restaurant);
//    @Query("SELECT t FROM TableEntity t JOIN FETCH t.restaurant WHERE t.id = :id")
//    TableEntity findTableEntityByIdWithRestaurant(@Param("id") Long id);
    List<TableEntity> findAllByTimeSlotsContainingAndCapacity(LocalDateTime timeSlot, Integer partySize);
}
