import axios from "axios";
import data from "bootstrap/js/src/dom/data";
axios.defaults.baseURL = 'http://localhost:8081'
axios.defaults.headers.post["Content-Type"] = 'application/json'

export const getAuthToken = () => {
    return window.localStorage.getItem("auth_token");
}

export const request = (method, url, data) => {
    let headers = {};
    if(getAuthToken() !== null && getAuthToken() !== "null") {
        headers = {"Authorization" : `Bearer ${getAuthToken()}`};
    }

    return axios({
        method: method,
        url: url,
        data: data
    })
}

export const setAuthToken = (token) => {
    if (token) {
        axios.defaults.headers.common['Authorization'] = `Bearer ${token}`;
        localStorage.setItem('token', token);
    } else {
        delete axios.defaults.headers.common['Authorization'];
        localStorage.removeItem('token');
    }
};
