import * as React from 'react';
import { request } from "../axios_helper";

export default class AuthContent extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: []
        };
    }

    componentDidMount() {
        request(
            "GET",
            "/api/restaurants",
            []
        ).then((response) => {
            this.setState({ data: response.data });
        });
    }

    render() {
        return (
            <div>
                {this.state.data && this.state.data.map((restaurant) => (
                    <div key={restaurant.restaurantId}>
                        <p>Name: {restaurant.name}</p>
                        <p>Cuisine Type: {restaurant.cuisineType}</p>
                        <p>Address: {restaurant.address}</p>
                        <p>User: {}</p>
                    </div>
                ))}
            </div>
        );
    }
}
