import React, { useState } from 'react';
import axios from 'axios';
import { useNavigate } from 'react-router-dom';
import 'bootstrap/dist/css/bootstrap.min.css';
import classNames from 'classnames';
import MembershipsEnum from './MembershipsEnum';

const AuthForm = () => {
    const navigate = useNavigate();
    const [activeTab, setActiveTab] = useState('login');
    const [credentials, setCredentials] = useState({
        firstName: '',
        lastName: '',
        email: '',
        password: '',
        phone: '',
        address: '',
        membershipLevel: ''
    });
    const [error, setError] = useState('');

    const handleChange = (e) => {
        const { name, value } = e.target;
        setCredentials({ ...credentials, [name]: value });
    };

    const handleLogin = async (e) => {
        e.preventDefault();
        try {
            const response = await axios.post('http://localhost:8081/api/login', {
                email: credentials.email,
                password: credentials.password
            });

            const { token } = response.data;
            localStorage.setItem('token', token);
            navigate('/');
        } catch (err) {
            setError('Login failed. Please check your credentials.');
        }
    };

    const handleRegister = async (e) => {
        e.preventDefault();
        try {
            await axios.post('http://localhost:8081/api/register', {
                firstName: credentials.firstName,
                lastName: credentials.lastName,
                email: credentials.email,
                password: credentials.password,
                phone: credentials.phone,
                address: credentials.address,
                membershipLevel: credentials.membershipLevel
            });
            setActiveTab('login');
            alert('Registration successful. Please log in.');
        } catch (err) {
            setError('Registration failed. Please try again.');
        }
    };

    return (
        <div className="container mt-5">
            <ul className="nav nav-pills nav-justified mb-3">
                <li className="nav-item">
                    <button
                        className={classNames('nav-link', { active: activeTab === 'login' })}
                        onClick={() => setActiveTab('login')}
                    >
                        Login
                    </button>
                </li>
                <li className="nav-item">
                    <button
                        className={classNames('nav-link', { active: activeTab === 'register' })}
                        onClick={() => setActiveTab('register')}
                    >
                        Register
                    </button>
                </li>
            </ul>

            {activeTab === 'login' && (
                <form onSubmit={handleLogin}>
                    <div className="form-outline mb-4">
                        <input
                            type="email"
                            name="email"
                            className="form-control"
                            placeholder="Email"
                            value={credentials.email}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <input
                            type="password"
                            name="password"
                            className="form-control"
                            placeholder="Password"
                            value={credentials.password}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    {error && <div className="text-danger mb-3">{error}</div>}
                    <button type="submit" className="btn btn-primary w-100">Login</button>
                </form>
            )}

            {activeTab === 'register' && (
                <form onSubmit={handleRegister}>
                    <div className="form-outline mb-4">
                        <input
                            type="text"
                            name="firstName"
                            className="form-control"
                            placeholder="First Name"
                            value={credentials.firstName}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <input
                            type="text"
                            name="lastName"
                            className="form-control"
                            placeholder="Last Name"
                            value={credentials.lastName}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <input
                            type="email"
                            name="email"
                            className="form-control"
                            placeholder="Email"
                            value={credentials.email}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <input
                            type="password"
                            name="password"
                            className="form-control"
                            placeholder="Password"
                            value={credentials.password}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <input
                            type="text"
                            name="phone"
                            className="form-control"
                            placeholder="Phone"
                            value={credentials.phone}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <input
                            type="text"
                            name="address"
                            className="form-control"
                            placeholder="Address"
                            value={credentials.address}
                            onChange={handleChange}
                            required
                        />
                    </div>
                    <div className="form-outline mb-4">
                        <select
                            name="membershipLevel"
                            className="form-control"
                            value={credentials.membershipLevel}
                            onChange={handleChange}
                            required
                        >
                            <option value="">Select Membership Type</option>
                            {MembershipsEnum().map((membership, index) => (
                                <option key={index} value={membership}>
                                    {membership}
                                </option>
                            ))}
                        </select>
                    </div>
                    {error && <div className="text-danger mb-3">{error}</div>}
                    <button type="submit" className="btn btn-success w-100">Register</button>
                </form>
            )}
        </div>
    );
};

export default AuthForm;
