import React, { createContext, useState, useEffect } from 'react';
import axios from 'axios';

export const CuisineContext = createContext();

export const CuisineProvider = ({ children }) => {
    const [cuisineTypes, setCuisineTypes] = useState([]);

    useEffect(() => {
        const fetchCuisineTypes = async () => {
            try {
                const response = await axios.get('http://localhost:8081/api/cuisineTypes');
                setCuisineTypes(response.data);
            } catch (error) {
                console.error('Error fetching cuisine types:', error);
            }
        };
        fetchCuisineTypes();
    }, []);

    return (
        <CuisineContext.Provider value={cuisineTypes}>
            {children}
        </CuisineContext.Provider>
    );
};