import React, { createContext, useState, useEffect } from 'react';
import axios from 'axios';

export const CustomerContext = createContext();

export const CustomerProvider = ({children}) => {
    const[customers, setCustomers] = useState([]);

    useEffect(() => {
        const fetchCustomers = async () => {
            try {
                const response = await axios.get("http://localhost:8081/api/customers");
                setCustomers(response.data)
            } catch (error) {
                console.log("Error fetching customers: ", error);
            }
        }
        fetchCustomers()
    }, []);

    return(
        <CustomerContext.Provider value={{customers}}>
            {children}
        </CustomerContext.Provider>
    )
}