import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { useParams } from 'react-router-dom';

const CustomerDetails = () => {
    const { id } = useParams();
    const [customer, setCustomer] = useState(null);

    useEffect(() => {
        const fetchCustomer = async () => {
            try {
                const response = await axios.get(`http://localhost:8081/api/customers/${id}`);
                setCustomer(response.data);
            } catch (error) {
                console.error('Error fetching customer:', error);
            }
        };

        fetchCustomer();
    }, [id]);

    if (!customer) {
        return <div>Loading...</div>;
    }

    return (
        <div>
            <h2>Customer Details</h2>
            <p className="card-text"><strong>Email:</strong> {customer.email}</p>
            <p className="card-text"><strong>Phone:</strong> {customer.phone}</p>
            <p className="card-text"><strong>Address:</strong> {customer.address}</p>
            <p className="card-text"><strong>Membership
                Level:</strong> {customer.membershipLevel}</p>
            <p className="card-text"><strong>Registration
                Date:</strong> {new Date(customer.registrationDate).toLocaleString()}</p>
        </div>
    );
}

export default CustomerDetails;
