import React from 'react';
import { Link, useNavigate } from 'react-router-dom';

const Header = () => {
    const navigate = useNavigate();

    // Check if the user is logged in by looking for a token in localStorage
    const isLoggedIn = localStorage.getItem('token');

    const handleLogout = () => {
        // Clear the token from localStorage
        localStorage.removeItem('token');
        // Redirect to the home page or login page after logging out
        navigate('/login');
    };

    return (
        <header className="header navbar navbar-expand-lg navbar-light bg-light">
            <div className="container">
                <button className="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span className="navbar-toggler-icon"></span>
                </button>
                <div className="collapse navbar-collapse" id="navbarNav">
                    <ul className="navbar-nav ml-auto">
                        <li className="nav-item">
                            <Link className="nav-link" to="/">Home</Link>
                        </li>
                        <li className="nav-item">
                            <Link className="nav-link" to="/restaurants">Restaurants</Link>
                        </li>
                        <li className="nav-item">
                            <Link className="nav-link" to="/reservations">Reservations</Link>
                        </li>
                        <li className="nav-item">
                            <Link className="nav-link" to="/reservations-past">Reservation history</Link>
                        </li>
                        <form className="form-inline mt-2 mt-md-0 ml-3">
                            {isLoggedIn ? (
                                <button className="btn btn-outline-danger my-2 my-sm-0" onClick={handleLogout}>Logout</button>
                            ) : (
                                <Link className="btn btn-outline-info my-2 my-sm-0" to="/login">Login</Link>
                            )}
                        </form>
                    </ul>
                </div>
            </div>
        </header>
    );
}

export default Header;
