import React, { useState, useEffect } from 'react';
import axios from 'axios';
import 'bootstrap/dist/css/bootstrap.min.css';
import {useNavigate} from "react-router-dom";
import {jwtDecode} from "jwt-decode";


const Reservations = () => {
    const navigate = useNavigate();

    const [reservations, setReservations] = useState([]);

    useEffect(() => {
        const fetchReservations = async () => {
            try {
                const token = localStorage.getItem("token");
                if (!token) {
                    console.error("No token found");
                    return;
                }
                const decodedToken = jwtDecode(token);
                console.log(decodedToken)
                const userId = decodedToken.iss;

                const response = await axios.get(`http://localhost:8081/api/reservations/by/${userId}`);
                setReservations(response.data);
            } catch (error) {
                console.error('Error fetching reservations:', error);
            }
        };

        fetchReservations();
    }, []);

    const handleEditReservation = async (reservationId) => {
        if(reservationId!=null) {
            navigate(`/reservations/reservationEdit/${reservationId}`);
        }
    }

    const handleCancelReservation = async (reservationID) => {
        try {
            await axios.delete(`http://localhost:8081/api/reservations/delete/${reservationID}`);
            setReservations(reservations.filter(reservation => reservation.reservationID !== reservationID));
            alert('Reservation canceled successfully!');
        } catch (error) {
            console.error('Error canceling reservation:', error);
            alert('An error occurred while canceling the reservation. Please try again later.');
        }
    };


    return (
        <div className="container">
            <h2>Reservations</h2>
            <div className="row">
                {reservations.map(reservation => (
                    <div key={reservation.reservationID} className="col-md-4 mb-4">
                        <div className="card">
                            <div className="card-body">
                                <div className="card-title">Reservation ID: {reservation.reservationID}</div>
                                <div className="card-text">Restaurant: {reservation.restaurant.name}</div>
                                <div className="card-text">Table Number: {reservation.table.id}</div>
                                {/* Format reservation date and time */}
                                <div className="card-text">Reservation
                                    Date: {new Date(reservation.checkInTime).toLocaleDateString('en-US', {
                                        weekday: 'long',
                                        year: 'numeric',
                                        month: 'long',
                                        day: 'numeric'
                                    })}</div>
                                <div className="card-text">Reservation
                                    Time: {new Date(reservation.checkInTime).toLocaleTimeString('en-US', {
                                        hour: 'numeric',
                                        minute: 'numeric',
                                        hour12: true
                                    })}</div>
                                {/* End of formatted date and time */}
                                <div className="card-text">Party Size: {reservation.partySize}</div>
                                <div className="card-text text-danger">Special
                                    Requests: {reservation.specialRequests}</div>
                                <div className="card-text">Status: {reservation.status}</div>
                                <div className="card-text text-danger">Grace period of 15 minutes +-</div>
                                <br/>
                                <div className="row">
                                    <div className="col">
                                        <button className="danger text-bg-warning border-0"
                                                onClick={() => handleEditReservation(reservation.reservationID)}>Edit
                                            Reservation
                                        </button>
                                    </div>
                                    <div className="col">
                                        <button className="danger text-bg-danger border-0"
                                                onClick={() => handleCancelReservation(reservation.reservationID)}>Cancel
                                            Reservation
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
    p

};

export default Reservations;
