package com.example.rezevirajmasa.demo.service;

import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.repository.ReservationRepository;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class ReservationSchedulerService {

    private final ReservationRepository reservationRepository;
    private final ReservationHistoryService reservationHistoryService;

    public ReservationSchedulerService(
            ReservationRepository reservationRepository,
            ReservationHistoryService reservationHistoryService) {
        this.reservationRepository = reservationRepository;
        this.reservationHistoryService = reservationHistoryService;
    }

    @Scheduled(cron = "0 0 0 * * ?")
    public void archivePastReservations() {
        LocalDateTime now = LocalDateTime.now();
        List<Reservation> pastReservations = reservationRepository.findAllByCheckInTimeBefore(now);

        for (Reservation reservation : pastReservations) {
            reservationHistoryService.moveReservationToHistory(reservation, "Past", null);
            reservationRepository.delete(reservation);
        }
    }
}