package com.example.rezevirajmasa.demo.service;

import com.example.rezevirajmasa.demo.model.*;
import org.springframework.security.core.userdetails.UserDetails;

import java.time.LocalDateTime;
import java.util.List;

public interface ReservationService {
    public void makeReservation(User user, TableEntity table, Restaurant restaurant, LocalDateTime localDateTime, LocalDateTime checkInTime, int partySize, String specialRequests);
    public Reservation makeReservationRest(Reservation reservation, User user);
    public List<Reservation> listAll();
    public Reservation findById(Long id);
    public Reservation getReservationById(Long reservationId);
    public boolean cancelReservation(Long reservationId);
    public List<Reservation> findReservationByUser(User user);
    public List<Reservation> findReservationsByUserPast(User user);
    public List<Reservation> findReservationsByTableAndDateRange(TableEntity table, LocalDateTime startDateTime, LocalDateTime endDateTime);
    List<Reservation> findReservationsToMove(LocalDateTime currentTime);
    void deleteReservation(Long reservationID);
}
