package com.example.rezevirajmasa.demo.service.impl;

import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.User;
import com.example.rezevirajmasa.demo.repository.ReservationHistoryRepository;
import com.example.rezevirajmasa.demo.service.ReservationHistoryService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class ReservationHistoryServiceImpl implements ReservationHistoryService {
    private final ReservationHistoryRepository reservationHistoryRepository;

    public ReservationHistoryServiceImpl(ReservationHistoryRepository reservationHistoryRepository) {
        this.reservationHistoryRepository = reservationHistoryRepository;
    }

    @Override
    public void moveReservationToHistory(Reservation reservation, String status, String cancellationReason) {
        Restaurant.ReservationHistory history = new Restaurant.ReservationHistory();
        history.setUser(reservation.getUser());
        history.setTable(reservation.getTable());
        history.setReservationDateTime(reservation.getReservationDateTime());
        history.setPartySize(reservation.getPartySize());
        history.setSpecialRequests(reservation.getSpecialRequests());
        history.setStatus(status);
        history.setCancellationReason(cancellationReason);
        history.setRestaurant(reservation.getRestaurant());
        history.setCheckInDate(reservation.getCheckInTime());
        history.setCancellationReason(cancellationReason != null ? cancellationReason : "");

        reservationHistoryRepository.save(history);
    }

    @Override
    public List<Restaurant.ReservationHistory> findAll() {
        return reservationHistoryRepository.findAll();
    }

    @Override
    public List<Restaurant.ReservationHistory> findByUser(User user) {
        return reservationHistoryRepository.findALlByUser(user);
    }

    @Override
    public void moveReservationsToPast(List<Restaurant.ReservationHistory> reservationsToMove) {
        for (Restaurant.ReservationHistory reservation : reservationsToMove) {
            reservation.setStatus("Past");
        }

        reservationHistoryRepository.saveAll(reservationsToMove);
    }

    @Override
    public List<Restaurant.ReservationHistory> findReservationsToMove(LocalDateTime currentTime) {
        return reservationHistoryRepository.findAllByCheckInDateBefore(currentTime);
    }
}
