package com.example.rezevirajmasa.demo.service.impl;

import com.example.rezevirajmasa.demo.config.security.SecurityConstants;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenService {

    public String getUserIdFromToken(String token) {
        try {
            String jwtToken = token.substring(7);

            Claims claims = Jwts.parser()
                    .setSigningKey(SecurityConstants.SECRET)
                    .parseClaimsJws(jwtToken)
                    .getBody();

            return claims.getSubject();  // Assumes 'sub' claim contains user ID
        } catch (ExpiredJwtException e) {
            throw new RuntimeException("Token has expired", e);
        } catch (SignatureException e) {
            throw new RuntimeException("Invalid token signature", e);
        } catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid token format", e);
        } catch (Exception e) {
            throw new RuntimeException("Could not extract user ID from token", e);
        }
    }
}