package com.example.rezevirajmasa.demo.web.filters;

import com.example.rezevirajmasa.demo.config.UserAuthProvider;
import io.jsonwebtoken.ExpiredJwtException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

import java.io.IOException;

@RequiredArgsConstructor
public class JwtAuthFilter extends OncePerRequestFilter {

    private final UserAuthProvider userAuthProvider;

    @Override
    protected void doFilterInternal(
            HttpServletRequest request,
            HttpServletResponse response,
            FilterChain filterChain) throws ServletException, IOException {
        String header = request.getHeader(HttpHeaders.AUTHORIZATION);

        String username = null;
        String jwt = null;

        if(header != null) {
            jwt = header.substring(7);
            String[] elements = header.split(" ");

            if(elements.length == 2 && "Bearer".equals(elements[0])) {
                try {
                    username = userAuthProvider.extractUsername(jwt); // logikata vidi ja
                    SecurityContextHolder.getContext().setAuthentication(
                            userAuthProvider.validateToken(elements[1])
                    );
                    if (username != null) {
                        System.out.println("Authenticated user: " + username); // Debug log
                        SecurityContextHolder.getContext().setAuthentication(
                                userAuthProvider.validateToken(jwt) // Ensure token validation works properly
                        );
                    }
                } catch (ExpiredJwtException e) {
                    String isRefreshToken = request.getHeader("isRefreshToken");
                    String requestURL = request.getRequestURL().toString();
                    if (isRefreshToken != null && isRefreshToken.equals("true") && requestURL.contains("refresh-token")) {
                        allowForRefreshToken(e, request);
                    } else
                        request.setAttribute("exception", e);

                } catch (RuntimeException e) {
                    SecurityContextHolder.clearContext();
                    throw e;
                }
            }
        }
        filterChain.doFilter(request, response);
    }

    private void allowForRefreshToken(ExpiredJwtException ex, HttpServletRequest request) {
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken(
                null, null, null);
        SecurityContextHolder.getContext().setAuthentication(usernamePasswordAuthenticationToken);
        request.setAttribute("claims", ex.getClaims());
    }
}
