package com.example.rezevirajmasa.demo.config;

import com.example.rezevirajmasa.demo.dto.ReservationDTO;
import com.example.rezevirajmasa.demo.dto.RestaurantDTO;
import com.example.rezevirajmasa.demo.dto.TableDTO;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import org.modelmapper.ModelMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModelMapperConfig {
    @Bean
    public ModelMapper modelMapper() {
        ModelMapper modelMapper = new ModelMapper();

        modelMapper.typeMap(Restaurant.class, RestaurantDTO.class).addMappings(mapper -> {
            mapper.map(Restaurant::getTablesList, RestaurantDTO::setTablesList);
        });

        modelMapper.typeMap(TableEntity.class, TableDTO.class).addMappings(mapper -> {
            mapper.map(TableEntity::getReservations, TableDTO::setReservations);
        });

        modelMapper.typeMap(Reservation.class, ReservationDTO.class).addMappings(mapper -> {
            mapper.map(Reservation::getReservationStatus, ReservationDTO::setReservationStatus);
            mapper.map(Reservation::getPaymentStatus, ReservationDTO::setPaymentStatus);
        });

        return modelMapper;
    }
}
