package com.example.rezevirajmasa.demo.mappers;

import com.example.rezevirajmasa.demo.dto.SignUpDto;
import com.example.rezevirajmasa.demo.dto.UserDto;
import com.example.rezevirajmasa.demo.model.MembershipLevel;
import com.example.rezevirajmasa.demo.model.User;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Component
public class UserMapperImpl implements UserMapper {

    @Override
    public UserDto toUserDto(User user) {
        if (user == null) {
            return null;
        }

        UserDto userDto = new UserDto();
        userDto.setId(user.getUserId());
        userDto.setFirstName(user.getFirstName());
        userDto.setLastName(user.getLastName());
        userDto.setEmail(user.getEmail());

        return userDto;
    }

    @Override
    public User signUpToUser(SignUpDto userDto) {
        if (userDto == null) {
            return null;
        }

        User user = new User();
        user.setEmail(userDto.getEmail());
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.setPassword(Arrays.toString(userDto.getPassword()));

        return user;
    }

    @Override
    public SignUpDto toSignUpDto(UserDto userDto) {
        if (userDto == null) {
            return null;
        }

        SignUpDto signUpDto = new SignUpDto();
        signUpDto.setEmail(userDto.getEmail());
        signUpDto.setFirstName(userDto.getFirstName());
        signUpDto.setLastName(userDto.getLastName());

        signUpDto.setPassword(new char[0]);

        return signUpDto;
    }

    @Override
    public User toUser(UserDto userDto) {
        if(userDto == null) {
            return null;
        }

        User user = new User();
        user.setLastName(userDto.getLastName());
        user.setFirstName(userDto.getFirstName());
        user.setPhone(userDto.getPhone());
        user.setMembershipLevel(MembershipLevel.valueOf(userDto.getMembershipLevel()));
        user.setAddress(userDto.getAddress());
        user.setEmail(userDto.getEmail());
        user.setUserId(userDto.getId());

        return user;
    }
}
