package com.example.rezevirajmasa.demo;

import com.example.rezevirajmasa.demo.model.MembershipLevel;
import com.example.rezevirajmasa.demo.model.exceptions.InvalidCustomerIdException;

import org.assertj.core.api.Assertions;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.annotation.Rollback;

import java.util.List;

@DataJpaTest
@AutoConfigureTestDatabase(replace = AutoConfigureTestDatabase.Replace.NONE)
@Rollback(false)
public class CustomerRepositoryTests {
    @Autowired private CustomerRepository customerRepository;

    @Test
    public void testAddNew(){
        Customer customer = new Customer();
        customer.setFirstName("Aleksandar");
        customer.setLastName("Panovski");
        customer.setEmail("lfc@liverpoo.com");
        customer.setAddress("5th Avenue, NY");
        customer.setPhone("+1 7743831817");
        customer.setMembershipLevel(MembershipLevel.GOLD);

        Customer savedCustomer = customerRepository.save(customer);

        Assertions.assertThat(savedCustomer).isNotNull();
        Assertions.assertThat(savedCustomer.getCustomerId()).isGreaterThan(0);
    }

    @Test
    public void findById() {
        Customer customer = customerRepository.findById(Long.valueOf(1)).orElseThrow(InvalidCustomerIdException::new);
        System.out.println(customer);
    }

    @Test
    public void testListAll() {
        List<Customer> customerList = customerRepository.findAll();
        Assertions.assertThat(customerList).hasSizeGreaterThan(0);

        for (Customer customer : customerList) {
            System.out.println(customer);
        }
    }

    @Test
    public void testUpdate() {
        Customer customer = customerRepository.findById(2L).orElseThrow(InvalidCustomerIdException::new);
        customer.setPhone("+38978450442");
        customerRepository.save(customer);

        Customer updatedCustomer = customerRepository.findById(2L).get();
        Assertions.assertThat(updatedCustomer.getEmail().equals("apano74@gmail.com"));
    }
}
