package com.example.rezevirajmasa.demo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.Data;

@Entity
@Table(name = "menu_tags")
@Data
public class MenuTag {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long menuTagId;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "menu_id", nullable = false)
    @JsonIgnore
    private Menu menu;

    @Column(name = "tag_name", nullable = false)
    private String tagName;

    @Column(name = "tag_value", nullable = false)
    private String tagValue;

    public MenuTag() {}

    public MenuTag(Menu menu, String tagName, String tagValue) {
        this.menu = menu;
        this.tagName = tagName;
        this.tagValue = tagValue;
    }
}

