package com.example.rezevirajmasa.demo.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;
import org.springframework.web.bind.annotation.ModelAttribute;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@Entity
@Getter
@Setter
@Table(name = "tables")
public class TableEntity {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "TableID")
    private Long id;

    @JsonBackReference
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "RestaurantID")
    private Restaurant restaurant;

    @Column(name = "Capacity")
    private int capacity;

    @Column(name = "tableLocation")
    private String tableLocation;

    @Column(name = "IsSmokingArea")
    private boolean isSmokingArea;

    @Column(name = "Description", length = 1000)
    private String description;

    @Column(name = "reservation_duration_hours", nullable = true)
    private int reservationDurationHours = 2;

    @OneToMany(mappedBy = "table", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @JsonIgnore
    private List<Reservation> reservations = new ArrayList<>();

    public void cleanUnusedTimeSlots(LocalDate threeDaysAgo) {
        reservations.removeIf(reservation -> reservation.getReservationDateTime().toLocalDate().isBefore(threeDaysAgo));
    }

    public boolean isAvailable(LocalDateTime desiredTimeSlot, int partySize) {
        if (this.capacity < partySize) {
            return false;
        }

        for (Reservation reservation : reservations) {
            LocalDateTime startTime = reservation.getReservationDateTime();
            LocalDateTime endTime = startTime.plusHours(reservation.getTable().getReservationDurationHours());

            if ((desiredTimeSlot.isEqual(startTime) || desiredTimeSlot.isAfter(startTime))
                    && desiredTimeSlot.isBefore(endTime)) {
                return false;
            }
        }

        return true;
    }

    public void addReservation(Reservation reservation) {
        LocalDateTime startTime = reservation.getReservationDateTime();
        LocalDateTime endTime = startTime.plusHours(reservation.getTable().getReservationDurationHours());
        for (LocalDateTime timeSlot = startTime; timeSlot.isBefore(endTime); timeSlot = timeSlot.plusMinutes(15)) {

        }
        this.reservations.add(reservation);
    }

    public void removeReservation(Reservation reservation) {
        LocalDateTime startTime = reservation.getReservationDateTime();
        LocalDateTime endTime = startTime.plusHours(reservation.getTable().getReservationDurationHours());
        for (LocalDateTime timeSlot = startTime; timeSlot.isBefore(endTime); timeSlot = timeSlot.plusMinutes(15)) {

        }
        this.reservations.remove(reservation);
    }

    public TableEntity(Restaurant restaurant, int capacity, String location, boolean isSmokingArea, String description, int reservationDurationHours) {
        this.restaurant = restaurant;
        this.capacity = capacity;
        this.tableLocation = location;
        this.isSmokingArea = isSmokingArea;
        this.description = description;
        this.reservationDurationHours = reservationDurationHours;
    }

    public TableEntity() {
    }
}
