package com.example.rezevirajmasa.demo.web.controller;

import com.example.rezevirajmasa.demo.dto.SignUpDto;
import com.example.rezevirajmasa.demo.dto.UserDto;
import com.example.rezevirajmasa.demo.mappers.UserMapper;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.User;
import com.example.rezevirajmasa.demo.service.ReservationHistoryService;
import com.example.rezevirajmasa.demo.service.UserService;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@Controller
@RequestMapping("/reservation-history")
public class ReservationHistoryController {
    private final ReservationHistoryService reservationHistoryService;
    private final UserService userService;
    private final UserMapper userMapper;

    public ReservationHistoryController(ReservationHistoryService reservationHistoryService, UserService userService, UserMapper userMapper) {
        this.reservationHistoryService = reservationHistoryService;
        this.userService = userService;
        this.userMapper = userMapper;
    }

    @GetMapping()
    public String showPastReservations(Authentication authentication, Model model) {
        List<Restaurant.ReservationHistory> reservationHistoryList;
        UserDto userDto = userService.findByEmail(authentication.getName());

        SignUpDto signUpDto = userMapper.toSignUpDto(userDto);

        User user = userMapper.signUpToUser(signUpDto);

        reservationHistoryList = reservationHistoryService.findByUser(user);
//        if(customer.getRole().equals(Role.ROLE_ADMIN)) {
//            reservationHistoryList = reservationHistoryService.findAll();
//        } else {
//            reservationHistoryList = reservationHistoryService.findByUser(User user);
//        }
        model.addAttribute("historyReservations", reservationHistoryList);
        model.addAttribute("bodyContent", "pastReservations");
        return "index";
    }
}
