import React, { createContext, useState, useEffect } from 'react';
import axios from 'axios';

export const RestaurantContext = createContext();

export const RestaurantProvider = ({ children }) => {
    const [restaurants, setRestaurants] = useState([]);

    useEffect(() => {
        if (restaurants.length > 0) return;
        const fetchRestaurants = async () => {
            try {
                const response = await axios.get('http://localhost:8081/api/restaurants');
                setRestaurants(response.data);
            } catch (error) {
                console.error('Error fetching restaurants:', error);
            }
        };
        fetchRestaurants();
    }, []);

    return (
        <RestaurantContext.Provider value={{ restaurants }}>
            {children}
        </RestaurantContext.Provider>
    );
};
