package com.example.rezevirajmasa.demo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Entity
@Table(name = "restaurants")
public class Restaurant {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "RestaurantID")
    private Long restaurantId;

    @Column(name = "Name", length = 100)
    private String name;

    @Column(name = "CuisineType", length = 50)
    private String cuisineType;

    @Column(name = "Address", length = 1000)
    private String address;

    @Column(name = "Phone", length = 20)
    private String phone;

    @Column(name = "OperatingHours", length = 100)
    private String operatingHours;

    @Column(name = "Website", length = 100)
    private String website;

    @Column(name = "SocialMediaLinks")
    private String socialMediaLinks;

    @Column(name = "Rating", precision = 3, scale = 2)
    private BigDecimal rating;

    @JsonManagedReference
    @OneToMany(mappedBy = "restaurant", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    private List<TableEntity> tablesList;

    public Restaurant() {
    }

    public Restaurant(String name, String cuisineType, String address, String phone, String operatingHours, String website, String socialMediaLinks, BigDecimal rating, List<TableEntity> tablesList) {
        this.name = name;
        this.cuisineType = cuisineType;
        this.address = address;
        this.phone = phone;
        this.operatingHours = operatingHours;
        this.website = website;
        this.socialMediaLinks = socialMediaLinks;
        this.rating = rating;
        this.tablesList = tablesList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCuisineType() {
        return cuisineType;
    }

    public void setCuisineType(String cuisineType) {
        this.cuisineType = cuisineType;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOperatingHours() {
        return operatingHours;
    }

    public void setOperatingHours(String operatingHours) {
        this.operatingHours = operatingHours;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getSocialMediaLinks() {
        return socialMediaLinks;
    }

    public void setSocialMediaLinks(String socialMediaLinks) {
        this.socialMediaLinks = socialMediaLinks;
    }

    public BigDecimal getRating() {
        return rating;
    }

    public void setRating(BigDecimal rating) {
        this.rating = rating;
    }

    public List<TableEntity> getTablesList() {
        return tablesList;
    }

    public void setTablesList(List<TableEntity> tablesList) {
        this.tablesList = tablesList;
    }

    public Long getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(Long restaurantId) {
        this.restaurantId = restaurantId;
    }

    @Entity
    @Table(name = "reservation_history")
    public static class ReservationHistory {

        @Id
        @GeneratedValue(strategy = GenerationType.IDENTITY)
        private Long id;

        @ManyToOne
        @JoinColumn(name = "customer_id")
        private User user;

        @ManyToOne
        @JoinColumn(name = "table_id")
        private TableEntity table;

        @ManyToOne
        @JoinColumn(name = "restaurant_id")
        private Restaurant restaurant;

        @Column(name = "reservation_datetime")
        private LocalDateTime reservationDateTime;

        @Column(name = "party_size")
        private int partySize;

        @Column(name = "special_requests")
        private String specialRequests;

        @Column(name = "status")
        private String status;

        @Column(name = "cancellation_reason")
        private String cancellationReason;

        @Column(name = "check_in_date")
        private LocalDateTime checkInDate;

        public ReservationHistory(User user, TableEntity table, Restaurant restaurant, LocalDateTime reservationDateTime, int partySize, String specialRequests, String status, String cancellationReason, LocalDateTime checkInDate) {
            this.user = user;
            this.table = table;
            this.restaurant = restaurant;
            this.reservationDateTime = reservationDateTime;
            this.partySize = partySize;
            this.specialRequests = specialRequests;
            this.status = status;
            this.cancellationReason = cancellationReason;
            this.checkInDate = checkInDate;
        }

        public ReservationHistory() {
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public User getUser() {
            return user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public TableEntity getTable() {
            return table;
        }

        public void setTable(TableEntity table) {
            this.table = table;
        }

        public LocalDateTime getReservationDateTime() {
            return reservationDateTime;
        }

        public void setReservationDateTime(LocalDateTime reservationDateTime) {
            this.reservationDateTime = reservationDateTime;
        }

        public int getPartySize() {
            return partySize;
        }

        public void setPartySize(int partySize) {
            this.partySize = partySize;
        }

        public String getSpecialRequests() {
            return specialRequests;
        }

        public void setSpecialRequests(String specialRequests) {
            this.specialRequests = specialRequests;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getCancellationReason() {
            return cancellationReason;
        }

        public void setCancellationReason(String cancellationReason) {
            this.cancellationReason = cancellationReason;
        }

        public Restaurant getRestaurant() {
            return restaurant;
        }

        public void setRestaurant(Restaurant restaurant) {
            this.restaurant = restaurant;
        }

        public LocalDateTime getCheckInDate() {
            return checkInDate;
        }

        public void setCheckInDate(LocalDateTime checkInDate) {
            this.checkInDate = checkInDate;
        }

        @Override
        public String toString() {
            return "ReservationHistory{" +
                    "id=" + id +
                    ", user=" + user +
                    ", table=" + table +
                    ", restaurant=" + restaurant +
                    ", reservationDateTime=" + reservationDateTime +
                    ", partySize=" + partySize +
                    ", specialRequests='" + specialRequests + '\'' +
                    ", status='" + status + '\'' +
                    ", cancellationReason='" + cancellationReason + '\'' +
                    ", checkInDate=" + checkInDate +
                    '}';
        }
    }
}
