import React from 'react';
import ReactDOM from 'react-dom/client';
import './index.css';
import App from './App';
import { CuisineProvider } from './components/CuisineContext';
import {RestaurantProvider} from "./components/RestaurantContext";
import {CustomerProvider} from "./components/CustomerContext";

const root = ReactDOM.createRoot(document.getElementById('root'));
root.render(
    <React.StrictMode>
        <CuisineProvider>
            <RestaurantProvider>
                <CustomerProvider>
                    <App />
                </CustomerProvider>
            </RestaurantProvider>
        </CuisineProvider>
    </React.StrictMode>
);
