package com.example.rezevirajmasa.demo.model;

import jakarta.persistence.*;

import java.time.LocalDateTime;
import java.time.LocalTime;

@Entity
@Table(name = "reservations")
public class Reservation {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "ReservationID")
    private Long reservationID;

    @ManyToOne
    @JoinColumn(name = "CustomerID")
    private Customer customer;

    @ManyToOne
    @JoinColumn(name = "TableNumber", nullable = false)
    private TableEntity table;

    @ManyToOne
    @JoinColumn(name = "RestaurantID", nullable = false)
    private Restaurant restaurant;

    @Column(name = "ReservationDateTime", nullable = false)
    private LocalDateTime reservationDateTime;

    @Column(name = "PartySize")
    private int partySize;

    @Column(name = "SpecialRequests")
    private String specialRequests;

    @Column(name = "Status", length = 20, nullable = false, columnDefinition = "VARCHAR default 'Pending'")
    private String status;

    @Column(name = "CheckInTime")
    private LocalDateTime checkInTime;

    @Column(name = "CheckOutTime")
    private LocalDateTime checkOutTime;

//    @Column(name = "TotalAmount", precision = 8, scale = 2)
//    private BigDecimal totalAmount;//rezervacija so depozit ako e

    @Column(name = "PaymentStatus", length = 20, nullable = false, columnDefinition = "VARCHAR default 'Unpaid'")
    private String paymentStatus;

    public Reservation() {

    }

    // Constructors, getters, setters, and other methods...

    @PrePersist
    private void prePersist() {
        // Set default values or perform any pre-persistence logic if needed
        if (status == null) {
            status = "Pending";
        }
        if (paymentStatus == null) {
            paymentStatus = "Unpaid";
        }
    }

    public Reservation(Customer customer, TableEntity table, Restaurant restaurant, LocalDateTime reservationDateTime, int partySize, String specialRequests, String status, LocalDateTime checkInTime, LocalDateTime checkOutTime, String paymentStatus) {
//        this.customer = customer;
        this.table = table;
        this.restaurant = restaurant;
        this.reservationDateTime = reservationDateTime;
        this.partySize = partySize;
        this.specialRequests = specialRequests;
        this.status = status;
        this.checkInTime = checkInTime;
        this.checkOutTime = checkOutTime;
        this.paymentStatus = paymentStatus;
    }

    public Long getReservationID() {
        return reservationID;
    }

    public void setReservationID(Long reservationID) {
        this.reservationID = reservationID;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public TableEntity getTable() {
        return table;
    }

    public void setTable(TableEntity table) {
        this.table = table;
    }

    public Restaurant getRestaurant() {
        return restaurant;
    }

    public void setRestaurant(Restaurant restaurant) {
        this.restaurant = restaurant;
    }

    public LocalDateTime getReservationDateTime() {
        return reservationDateTime;
    }

    public void setReservationDateTime(LocalDateTime reservationDateTime) {
        this.reservationDateTime = reservationDateTime;
    }

    public int getPartySize() {
        return partySize;
    }

    public void setPartySize(int partySize) {
        this.partySize = partySize;
    }

    public String getSpecialRequests() {
        return specialRequests;
    }

    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LocalDateTime getCheckInTime() {
        return checkInTime;
    }

    public void setCheckInTime(LocalDateTime checkInTime) {
        this.checkInTime = checkInTime;
    }

    public LocalDateTime getCheckOutTime() {
        return checkOutTime;
    }

    public void setCheckOutTime(LocalDateTime checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public String getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @Override
    public String toString() {
        return "Reservation{" +
                "reservationID=" + reservationID +
                ", customer=" + customer +
                ", table=" + table +
                ", restaurant=" + restaurant +
                ", reservationDateTime=" + reservationDateTime +
                ", partySize=" + partySize +
                ", specialRequests='" + specialRequests + '\'' +
                ", status='" + status + '\'' +
                ", checkInTime=" + checkInTime +
                ", checkOutTime=" + checkOutTime +
                ", paymentStatus='" + paymentStatus + '\'' +
                '}';
    }
}