import React from 'react';
import StarRating from './StarRating';

const RestaurantCard = ({ restaurant, onDetailClick }) => {
    return (
        <div className="col-md-4 mb-4">
            <div className="card">
                <div className="card-body">
                    <h5 className="card-title">
                        {restaurant.name} <StarRating rating={restaurant.rating} />
                    </h5>
                    <p className="card-text">{restaurant.cuisineType}</p>
                    <p className="card-text">{restaurant.operatingHours}</p>
                    <p className="card-text">Ul. {restaurant.address}</p>
                </div>
                <button onClick={() => onDetailClick(restaurant.restaurantId)} className="btn btn-primary">View Details</button>
            </div>
        </div>
    );
};

export default RestaurantCard;
