import { BrowserRouter as Router, Route, Routes } from 'react-router-dom';
import Customers from './components/Customers';
import Layout from "./components/Layout";
import React, {useEffect, useState} from 'react';
import CustomerFormContainer from "./components/CustomerFormContainer";
import CustomerDetails from "./components/CustomerDetails";
import ErrorPage from "./components/ErrorPage";
import Restaurants from "./components/Restaurants";
import Reservations from "./components/Reservations";
import RestaurantDetails from "./components/RestaurantDetails";
import ReservationConfirmation from "./components/ReservationConfirmation";
import ReservationEdit from "./components/ReservationEdit";

const App = () => {
    return (
        <Router>
            <Layout>
                <Routes>
                    <Route path="/" element={<Home />} />
                    <Route path="/customers" element={<Customers />} />
                    <Route path="/customers/add" element={<CustomerFormContainer/>} />
                    <Route path="/customers/:id" element={<CustomerDetails />} />
                    <Route path="/customers/edit/:id" element={<CustomerFormContainer/>} />
                    <Route path="/restaurants" element={<Restaurants />} />
                    <Route path="/restaurants/:id" element={<RestaurantDetails />} />
                    <Route path="/reservations" element={<Reservations />} />
                    <Route path="/reservationConfirmation/:tableNumber/:timeSlot/:restaurantId" element={<ReservationConfirmation />} />
                    <Route path="/reservations/reservationEdit/:reservationId" element={<ReservationEdit />} />
                    <Route path="/error" element={<ErrorPage/>}/>
                </Routes>
            </Layout>
        </Router>
    );
}


const Home = () => {
    const todayDate = new Date().toISOString().split('T')[0]; // Get today's date in 'YYYY-MM-DD' format

    const [date, setDate] = useState(todayDate);
    const [selectedTime, setSelectedTime] = useState('');
    const [numPeople, setNumPeople] = useState(2);
    const [searchValue, setSearchValue] = useState('');
    const [timeSlots, setTimeSlots] = useState([]);

    useEffect(() => {
        if (date) {
            const selectedDate = new Date(date);
            const today = new Date();
            const isToday = selectedDate.toDateString() === today.toDateString();

            const startHour = isToday ? today.getHours() : 9;
            const startMinute = isToday ? Math.ceil(today.getMinutes() / 15) * 15 : 0;

            let currentTime = new Date(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate(), startHour, startMinute);
            const endTime = new Date(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate(), 23, 30);

            const slots = [];
            while (currentTime <= endTime) {
                const option = currentTime.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: false });
                slots.push(option);
                currentTime.setMinutes(currentTime.getMinutes() + 15); // Increment by 15 minutes
            }

            setTimeSlots(slots);
        }
    }, [date]);

    const handleDateChange = (e) => {
        setDate(e.target.value);
    };

    const handleTimeChange = (e) => {
        setSelectedTime(e.target.value);
    };

    const handleNumPeopleChange = (e) => {
        setNumPeople(e.target.value);
    };

    const handleInputChange = (event) => {
        setSearchValue(event.target.value);
    };

    const handleSubmit = (e) => {
        e.preventDefault();
        console.log(date);
        console.log(selectedTime);
        console.log(numPeople);
        console.log(searchValue);
    };

    const today = new Date().toISOString().split('T')[0];

    return (
        <div className="container">
            <h2>Home</h2>
            <p>Welcome to My Awesome App!</p>
            <form className="row g-2 align-items-center" onSubmit={handleSubmit}>
                <div className="col-auto">
                    <input className="form-control me-2" type="date" value={date} onChange={handleDateChange}
                           min={today}/>
                </div>
                <div className="col-auto">
                    <select className="form-select" onChange={handleTimeChange}>
                        {timeSlots.map((slot, index) => (
                            <option key={index} value={slot}>{slot}</option>
                        ))}
                    </select>
                </div>
                <div className="col-auto">
                    <select className="form-select" value={numPeople} onChange={handleNumPeopleChange}>
                        {[...Array(20).keys()].map((num) => (
                            <option key={num + 1} value={num + 1}>{num + 1}</option>
                        ))}
                    </select>
                </div>
                <div className="col-auto">
                    <input
                        className="form-control me-2"
                        type="search"
                        name="search"
                        placeholder="Restaurant or Cuisine"
                        aria-label="Search"
                        value={searchValue} // Set the value of the input field
                        onChange={handleInputChange} // Call the event handler on change
                    />
                </div>
                <div className="col-auto">
                    <button className="btn btn-outline-success" type="submit">Search</button>
                </div>
            </form>
        </div>
    );
}


export default App;
