import React from 'react';
import MembershipsEnum from "./MembershipsEnum";

const CustomersForm = ({ formData, handleChange, handleSubmit, membershipOptions, isEdit}) => {
    return (
        <div>
            <form onSubmit={handleSubmit} method="post">
                <div>
                    <label htmlFor="firstName">First Name</label>
                    <div>
                        <input
                            type="text"
                            id="firstName"
                            name="firstName"
                            value={formData.firstName}
                            onChange={handleChange}
                            required
                        />
                    </div>
                </div>
                <div>
                    <label htmlFor="lastName">Last Name</label>
                    <div>
                        <input
                            type="text"
                            id="lastName"
                            name="lastName"
                            value={formData.lastName}
                            onChange={handleChange}
                            required
                        />
                    </div>
                </div>
                <div>
                    <label htmlFor="email">Email</label>
                    <div>
                        <input
                            type="email"
                            id="email"
                            name="email"
                            value={formData.email}
                            onChange={handleChange}
                            required
                        />
                    </div>
                </div>
                <div>
                    <label htmlFor="password">Password</label>
                    <div>
                        <input
                            type="password"
                            id="password"
                            name="password"
                            value={formData.password}
                            onChange={handleChange}
                            required
                        />
                    </div>
                </div>
                <div>
                    <label htmlFor="phone">Phone</label>
                    <div>
                        <input
                            type="text"
                            id="phone"
                            name="phone"
                            value={formData.phone}
                            onChange={handleChange}
                            required
                        />
                    </div>
                </div>
                <div>
                    <label htmlFor="address">Address</label>
                    <div>
                        <input
                            type="text"
                            id="address"
                            name="address"
                            value={formData.address}
                            onChange={handleChange}
                            required
                        />
                    </div>
                </div>
                <div>
                    <label htmlFor="membershipLevel">Membership Type</label>
                    <div>
                        <select
                            id="membershipLevel"
                            name="membershipLevel"
                            value={formData.membershipLevel}
                            onChange={handleChange}
                            required
                        >
                            {MembershipsEnum().map((membership, index) => (
                                <option key={index} value={membership}>
                                    {membership}
                                </option>
                            ))}
                        </select>
                    </div>
                </div>
                <button type="submit">{isEdit ? 'Update' : 'Register'}</button>
            </form>
        </div>
    );
};

export default CustomersForm;
