import React from 'react';
import StarRating from "./StarRating";

const RestaurantInfo = ({ restaurant }) => {
    return (
        <div className="card-body">
            <h2>
                {restaurant.name} <StarRating key={restaurant.id} rating={restaurant.rating}/>
            </h2>
            <p className="card-text">{restaurant.cuisineType}</p> {/* Assuming cuisineType is provided */}
            <p className="card-text">{restaurant.operatingHours}</p> {/* Assuming operatingHours is provided */}
            <p className="card-text">Ul. {restaurant.address}</p> {/* Assuming address is provided */}
        </div>
    );
}

export default RestaurantInfo;
