package com.example.rezevirajmasa.demo.model;

import jakarta.persistence.*;

import java.math.BigDecimal;

@Entity
@Table(name = "menus")
public class Menu {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "MenuID")
    private Long menuID;

    @ManyToOne
    @JoinColumn(name = "RestaurantID", nullable = false)
    private Restaurant restaurant;

    @Column(name = "ItemName", length = 100)
    private String itemName;

    @Column(name = "Category", length = 50)
    private String category;

    @Column(name = "Price", precision = 8, scale = 2)
    private BigDecimal price;

    @Column(name = "Description")
    private String description;

    @Column(name = "DietaryInformation", columnDefinition = "JSONB")
    private String dietaryInformation;

    public Menu() {
    }

    public Menu(Restaurant restaurant, String itemName, String category, BigDecimal price, String description, String dietaryInformation) {
        this.restaurant = restaurant;
        this.itemName = itemName;
        this.category = category;
        this.price = price;
        this.description = description;
        this.dietaryInformation = dietaryInformation;
    }
}