package com.example.rezevirajmasa.demo.model;

import jakarta.persistence.*;

import java.io.Serializable;

@Entity
@Table(name = "restaurantMenus")
public class RestaurantMenu {
    @EmbeddedId
    private RestaurantMenuId id;

    @ManyToOne
    @MapsId("restaurantID")
    @JoinColumn(name = "RestaurantID", nullable = false)
    private Restaurant restaurant;

    @ManyToOne
    @MapsId("menuID")
    @JoinColumn(name = "MenuID", nullable = false)
    private Menu menu;

    public RestaurantMenu(Restaurant restaurant, Menu menu) {
        this.restaurant = restaurant;
        this.menu = menu;
    }

    public RestaurantMenu() {
    }

    @Embeddable
    public static class RestaurantMenuId implements Serializable {

        @Column(name = "RestaurantID")
        private Long restaurantID;

        @Column(name = "MenuID")
        private Long menuID;
    }
}