package com.example.rezevirajmasa.demo.service;

import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;

import java.time.LocalDateTime;
import java.util.List;

public interface ReservationService {
    public void makeReservation(Customer customer, TableEntity table, Restaurant restaurant, LocalDateTime localDateTime, LocalDateTime checkInTime, int partySize, String specialRequests);
    public Reservation makeReservationRest(Reservation reservation);
    public List<Reservation> listAll();
    public Reservation findById(Long id);
    public Reservation getReservationById(Long reservationId);
    public boolean cancelReservation(Long reservationId);
    public List<Reservation> findReservationByCustomer(Customer customer);
    public List<Reservation> findReservationsByTableAndDateRange(TableEntity table, LocalDateTime startDateTime, LocalDateTime endDateTime);
    List<Reservation> findReservationsToMove(LocalDateTime currentTime);
    void deleteReservation(Long reservationID);
}
