package com.example.rezevirajmasa.demo.service;

import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import jakarta.persistence.Table;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

public interface TableService {
    List<TableEntity> listall();
    TableEntity findById(Long id);
//    void save(int numberOfTables, List<Integer> tableCapacities, List<String> tableLocations, List<String> tableSmokingAreas, List<String> tableDescriptions, Restaurant restaurant);
    void deleteTimeSlotsForReservation(Long tableId, LocalDateTime reservationTime);
    void canceledTimeSlots(Long tableId, LocalDateTime reservationTime);
    TableEntity getTableByNumber(Long number);
    TableEntity deleteTable(Long number);
    void saveTable(TableEntity table);
    boolean hasAvailableTimeSlotsForRestaurantAndDate(Restaurant restaurant, LocalDate today);
    public boolean hasAvailableTimeSlotsForTableAndDate(TableEntity table, LocalDate date);
}
