package com.example.rezevirajmasa.demo.web.controller;

import com.example.rezevirajmasa.demo.model.MembershipLevel;
import com.example.rezevirajmasa.demo.model.Role;
import com.example.rezevirajmasa.demo.service.CustomerService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CustomerController {
    private final CustomerService customerService;

    public CustomerController(CustomerService customerService) {
        this.customerService = customerService;
    }

    @GetMapping("/customers")
    public String showCustomers(Model model) {
        model.addAttribute("bodyContent", "customers");
        model.addAttribute("customers", customerService.listAll());
        model.addAttribute("memberships", MembershipLevel.values());
        model.addAttribute("roles", Role.values());
        return "index";
    }
    @GetMapping("/customers/add")
    public String showAddForm(Model model) {
        model.addAttribute("bodyContent", "CustomersForm");
        model.addAttribute("memberships", MembershipLevel.values());
        model.addAttribute("roles", Role.values());
        return "index";
    }
    @PostMapping("/customers/add")
    public String createCustomer(@RequestParam String firstName,
                                 @RequestParam String lastName,
                                 @RequestParam String email,
                                 @RequestParam String password,
                                 @RequestParam String phone,
                                 @RequestParam String address,
                                 @RequestParam MembershipLevel membershipLevel,
                                 @RequestParam Role role) {
        customerService.registration(firstName, lastName, email, password, phone, address, membershipLevel, role);
        return "redirect:/customers";
    }
}
