package com.example.rezevirajmasa.demo.web.controller;

import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.Role;
import com.example.rezevirajmasa.demo.service.CustomerService;
import com.example.rezevirajmasa.demo.service.ReservationHistoryService;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@Controller
@RequestMapping("/reservation-history")
public class ReservationHistoryController {
    private final ReservationHistoryService reservationHistoryService;
    private final CustomerService customerService;

    public ReservationHistoryController(ReservationHistoryService reservationHistoryService, CustomerService customerService) {
        this.reservationHistoryService = reservationHistoryService;
        this.customerService = customerService;
    }

    @GetMapping()
    public String showPastReservations(Authentication authentication, Model model) {
        List<Restaurant.ReservationHistory> reservationHistoryList;
        Customer customer = customerService.findByEmail(authentication.getName());
        if(customer.getRole().equals(Role.ROLE_ADMIN)) {
            reservationHistoryList = reservationHistoryService.findAll();
        } else {
            reservationHistoryList = reservationHistoryService.findByCustomer(customer);
        }
        model.addAttribute("historyReservations", reservationHistoryList);
        model.addAttribute("bodyContent", "pastReservations");
        return "index";
    }
}
