// CustomerFormContainer.js
import React, { useState, useEffect } from 'react';
import axios from 'axios';
import CustomerForm from './CustomersForm';
import MembershipsEnum from "./MembershipsEnum";
import {useNavigate, useParams} from "react-router-dom";

const CustomerFormContainer = () => {
    const navigate = useNavigate();
    const [formData, setFormData] = useState({
        firstName: '',
        lastName: '',
        email: '',
        password: '',
        phone: '',
        address: '',
        membershipLevel: MembershipsEnum()[0]
    });

    const { id } = useParams();
    const [customer, setCustomer] = useState(null);

    useEffect(() => {
        if (id) {
            // Fetch customer data only if in edit mode
            const fetchCustomer = async () => {
                try {
                    const response = await axios.get(`http://localhost:8080/api/customers/${id}`);
                    const customerData = response.data;
                    setFormData({
                        firstName: customerData.firstName || '',
                        lastName: customerData.lastName || '',
                        email: customerData.email || '',
                        password: '', // For security reasons, the password field should not be pre-filled
                        phone: customerData.phone || '',
                        address: customerData.address || '',
                        membershipLevel: customerData.membershipLevel || MembershipsEnum()[0]
                    });
                } catch (error) {
                    console.error('Error fetching customer:', error);
                }
            };

            fetchCustomer();
        }
    }, [id]);

    const handleChange = (e) => {
        setFormData({ ...formData, [e.target.name]: e.target.value });
    };

    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            if (customer) {
                await axios.put(`http://localhost:8080/api/customers/edit/${customer.id}`, formData);
            } else {
                await axios.post("http://localhost:8080/api/customers", formData);
            }
            navigate("/customers");
        } catch (error) {
            navigate("/error");
        }
    };

    return (
        <CustomerForm
            formData={formData}
            handleChange={handleChange}
            handleSubmit={handleSubmit}
            membershipOptions={MembershipsEnum()}
            isEdit={!!customer} // Pass a boolean indicating whether it's an update
        />
    );
};

export default CustomerFormContainer;
