//package com.example.rezevirajmasa.demo.bootstrap;
//
//import com.example.rezevirajmasa.demo.model.Reservation;
//import com.example.rezevirajmasa.demo.model.Restaurant;
//import com.example.rezevirajmasa.demo.model.TableEntity;
//import com.example.rezevirajmasa.demo.service.ReservationService;
//import com.example.rezevirajmasa.demo.service.RestaurantService;
//import com.example.rezevirajmasa.demo.service.TableService;
//import jakarta.annotation.PostConstruct;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.ApplicationArguments;
//import org.springframework.stereotype.Component;
//
//import java.time.LocalDate;
//import java.time.LocalDateTime;
//import java.time.LocalTime;
//import java.time.format.DateTimeFormatter;
//import java.util.ArrayList;
//import java.util.List;
//
//@Component
//public class DataInitialization {
//    private final RestaurantService restaurantService;
//    private final TableService tableService;
//    private final ReservationService reservationService;
//
//    public DataInitialization(RestaurantService restaurantService, TableService tableService, ReservationService reservationService) {
//        this.restaurantService = restaurantService;
//        this.tableService = tableService;
//        this.reservationService = reservationService;
//    }
//
////    @PostConstruct
//    public void initData() {
//        for(Restaurant restaurant : restaurantService.listall()) {
//            extendTimeSlotsIndefinitely(restaurant);
//        }
//    }
//
//    private void extendTimeSlotsIndefinitely(Restaurant restaurant) {
//        while (true) {
//            String[] hours = restaurant.getOperatingHours().split("-");
//            LocalTime startTime = LocalTime.parse(hours[0], DateTimeFormatter.ofPattern("HH:mm"));
//            LocalTime endTime = LocalTime.parse(hours[1], DateTimeFormatter.ofPattern("HH:mm"));
//
//            // Get the current date and time
//            LocalDateTime currentDateTime = LocalDateTime.now().with(startTime);
//
//            // Calculate the end date (current date + 3 days)
//            LocalDateTime endDate = LocalDateTime.now().with(endTime).plusDays(3);
//
//            List<TableEntity> tables = restaurant.getTablesList();
//            for (TableEntity table : tables) {
//                List<LocalDateTime> existingTimeSlots = table.getTimeSlots();
//                List<Reservation> existingReservations = reservationService.findReservationsByTableAndDateRange(table, currentDateTime, endDate);
//                List<LocalDateTime> newTimeSlots = generateTimeSlots(currentDateTime, endDate, existingReservations, existingTimeSlots, startTime, endTime);
//                existingTimeSlots.addAll(newTimeSlots);
//                tableService.saveTable(table);
//            }
//
//            // Sleep for a period before generating time slots again
//            try {
//                // Sleep for 24 hours
//                Thread.sleep(24 * 60 * 60 * 1000);
//            } catch (InterruptedException e) {
//                // Handle interrupted exception
//                break;
//            }
//        }
//    }
//
//    private List<LocalDateTime> generateTimeSlots(LocalDateTime startDate, LocalDateTime endDate, List<Reservation> existingReservations, List<LocalDateTime> existingTimeSlots, LocalTime startTime, LocalTime endTime) {
//        List<LocalDateTime> timeSlots = new ArrayList<>();
//        LocalDateTime currentDateTime = startDate;
//        LocalTime currentTime = startTime;
//        LocalDate currentDate = LocalDate.now(); // Get the current date
//
//        // Generate time slots until the end date
//        while (currentDateTime.isBefore(endDate)) {
//            // Ensure the current date is within the restaurant's opening hours
//            if (currentDateTime.toLocalTime().isBefore(startTime)) {
//                currentDateTime = currentDateTime.plusDays(1).with(startTime); // Move to the next day and set the start time
//                continue; // Skip generating time slots for this day
//            }
//
//            final LocalDateTime currentTimeSlotStart = currentDateTime; // Declare a final local variable
//
//            // Check if the current time slot overlaps with existing reservations
//            boolean overlapsReservations = existingReservations.stream()
//                    .anyMatch(reservation -> isOverlapping(currentTimeSlotStart, currentTimeSlotStart.plusMinutes(15), reservation.getCheckInTime(), reservation.getCheckOutTime()));
//            boolean overlapsExistingTimeSlots = existingTimeSlots.stream()
//                    .anyMatch(existingSlot -> isOverlapping(currentTimeSlotStart, currentTimeSlotStart.plusMinutes(15), existingSlot, existingSlot.plusMinutes(15)));
//
//            if (!overlapsReservations && !overlapsExistingTimeSlots) {
//                timeSlots.add(currentDateTime);
//            }
//
//            // Move to the next time slot (add 15 minutes
//            currentDateTime = currentDateTime.plusMinutes(15);
//        }
//
//        return timeSlots;
//    }
//
//    private boolean isOverlapping(LocalDateTime start1, LocalDateTime end1, LocalDateTime start2, LocalDateTime end2) {
//        return start1.isBefore(end2) && start2.isBefore(end1);
//    }
//}