package com.example.rezevirajmasa.demo.bootstrap;

import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.service.ReservationHistoryService;
import com.example.rezevirajmasa.demo.service.ReservationService;
import org.springframework.stereotype.Component;

import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class ReservationInitializer {
    private final ReservationHistoryService reservationHistoryService;
    private final ReservationService reservationService;

    public ReservationInitializer(ReservationHistoryService reservationHistoryService, ReservationService reservationService) {
        this.reservationHistoryService = reservationHistoryService;
        this.reservationService = reservationService;
    }

    @PostConstruct
    public void initializePastReservations() {
        LocalDateTime currentTime = LocalDateTime.now();
        List<Reservation> reservationsToMove = reservationService.findReservationsToMove(currentTime);

        List<Restaurant.ReservationHistory> reservationHistories = reservationsToMove.stream()
                .map(reservation -> new Restaurant.ReservationHistory(
                        reservation.getCustomer(),
                        reservation.getTable(),
                        reservation.getRestaurant(),
                        reservation.getReservationDateTime(),
                        reservation.getPartySize(),
                        reservation.getSpecialRequests(),
                        "Done",
                        null, // You can set cancellation reason if needed, it's not clear from the code provided
                        reservation.getCheckInTime() // Use currentTime for check-in date
                ))
                .collect(Collectors.toList());

        reservationHistoryService.moveReservationsToPast(reservationHistories);

        reservationsToMove.forEach(reservation -> reservationService.deleteReservation(reservation.getReservationID()));
    }

}
