package com.example.rezevirajmasa.demo.repository;

import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import org.springframework.data.jpa.repository.JpaRepository;

import java.time.LocalDateTime;
import java.util.List;

public interface ReservationRepository extends JpaRepository<Reservation, Long> {
    List<Reservation> findAllByCustomer(Customer customer);
    List<Reservation> findByTableAndCheckInTimeBetween(TableEntity table, LocalDateTime startTime, LocalDateTime endTime);

    List<Reservation> findByTable(TableEntity tableEntity);
    List<Reservation> findAllByCheckInTimeBefore(LocalDateTime currentTime);
    List<Reservation> findByCheckInTimeAfterAndCheckInTimeBefore(LocalDateTime startTime, LocalDateTime endTime);
}
