package com.example.rezevirajmasa.demo.web.controller;

import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import com.example.rezevirajmasa.demo.service.CustomerService;
import com.example.rezevirajmasa.demo.service.ReservationService;
import com.example.rezevirajmasa.demo.service.RestaurantService;
import com.example.rezevirajmasa.demo.service.TableService;
import net.sourceforge.htmlunit.xpath.operations.Mod;
import org.springframework.boot.Banner;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.ui.Model;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Controller
public class RestaurantController {
    private final RestaurantService restaurantService;
    private final TableService tableService;

    public RestaurantController(RestaurantService restaurantService, TableService tableService) {
        this.restaurantService = restaurantService;
        this.tableService = tableService;
    }

    @GetMapping("/restaurants")
    public String showRestaurants(@RequestParam(required = false) String search, Model model) {
        List<Restaurant> restaurantList;
        if(search == null) {
            restaurantList = this.restaurantService.listall();
        } else {
            restaurantList = restaurantService.listRestaurantBy(search);
        }

        for (Restaurant restaurant : restaurantList) {
            // Initialize a set to store unique capacities for this restaurant
            Set<Integer> uniqueCapacities = new HashSet<>();

            // Populate uniqueCapacities with unique capacity values for tables in this restaurant
            for (TableEntity table : restaurant.getTablesList()) {
                uniqueCapacities.add(table.getCapacity());
            }

            // Add uniqueCapacities to the model for this restaurant
            model.addAttribute("uniqueCapacities_" + restaurant.getRestaurantId(), uniqueCapacities);
        }
        model.addAttribute("bodyContent", "restaurants");
        model.addAttribute("restaurants", restaurantList);
        return "index";
    }

    @GetMapping("/restaurants/{tableNumber}")
    public String reserveTable(@PathVariable Long tableNumber, Model model) {
        TableEntity tableEntity = tableService.findById(tableNumber);
        Restaurant restaurant = tableEntity.getRestaurant();

        model.addAttribute("table", tableEntity);
        model.addAttribute("restaurant", restaurant);

        model.addAttribute("bodyContent", "reservationConfirmation.html");

        return "index";
    }

    @GetMapping("/restaurants/add")
    public String showAddRestaurantForm(Model model) {
        model.addAttribute("bodyContent", "restaurantForm");
        return "index";
    }

    @PostMapping("/register-restaurant")
    public String saveRestaurant(@RequestParam String name,
                                 @RequestParam String cuisineType,
                                 @RequestParam String address,
                                 @RequestParam String phone,
                                 @RequestParam String operatingHours,
                                 @RequestParam BigDecimal rating,
                                 @RequestParam int numberOfTables,
                                 @RequestParam List<Integer> tableCapacities,
                                 @RequestParam List<String> tableLocations,
                                 @RequestParam List<String> tableSmokingAreas,
                                 @RequestParam List<String> tableDescriptions,
                                 @RequestParam String socialMediaLinks,
                                 @RequestParam String website,
                                 Model model) {

        Restaurant restaurant = new Restaurant();
        restaurant.setName(name);
        restaurant.setCuisineType(cuisineType);
        restaurant.setAddress(address);
        restaurant.setPhone(phone);
        restaurant.setOperatingHours(operatingHours);
        restaurant.setRating(rating);
        restaurant.setSocialMediaLinks(socialMediaLinks);
        restaurant.setWebsite(website);

        restaurantService.save(restaurant, numberOfTables, tableCapacities, tableLocations, tableSmokingAreas, tableDescriptions);
        model.addAttribute("bodyContent", "restaurants");
        return "redirect:/restaurants";
    }

}
