package com.example.rezevirajmasa.demo.repository;

import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.time.LocalDateTime;
import java.util.List;

public interface TableRepository extends JpaRepository<TableEntity, Long> {
    List<TableEntity> findByRestaurant(Restaurant restaurant);
    List<TableEntity> findAllByCapacityGreaterThanEqual(int capacity);
    @Query("SELECT t FROM TableEntity t WHERE t.capacity >= :capacity AND NOT EXISTS (" +
            "SELECT r FROM t.reservations r WHERE r.checkInTime <= :checkOutTime AND r.checkOutTime >= :checkInTime)")
    List<TableEntity> findAvailableTables(@Param("checkInTime") LocalDateTime checkInTime,
                                          @Param("checkOutTime") LocalDateTime checkOutTime,
                                          @Param("capacity") int capacity);
}
