package com.example.rezevirajmasa.demo.config;

import com.example.rezevirajmasa.demo.dto.ReservationDTO;
import com.example.rezevirajmasa.demo.dto.RestaurantDTO;
import com.example.rezevirajmasa.demo.dto.TableDTO;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;
import org.modelmapper.ModelMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModelMapperConfig {
    @Bean
    public ModelMapper modelMapper() {
        ModelMapper modelMapper = new ModelMapper();

        // Map Restaurant to RestaurantDTO
        modelMapper.typeMap(Restaurant.class, RestaurantDTO.class).addMappings(mapper -> {
            mapper.map(Restaurant::getTablesList, RestaurantDTO::setTablesList);
        });

        // Map TableEntity to TableDTO
        modelMapper.typeMap(TableEntity.class, TableDTO.class).addMappings(mapper -> {
            mapper.map(TableEntity::getReservations, TableDTO::setReservations);
        });

        // Map Reservation to ReservationDTO
        modelMapper.typeMap(Reservation.class, ReservationDTO.class);

        return modelMapper;
    }
}
