package com.example.rezevirajmasa.demo.dto;

import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;

import java.math.BigDecimal;
import java.time.LocalDateTime;

public class ReservationDTO {
    private Long reservationID;
    private String userEmail;
    private BigDecimal rating;
    private Long tableNumber;
    private LocalDateTime reservationDateTime;
    private LocalDateTime checkInTime;
    private Restaurant restaurant;
    private int partySize;
    private String status;
    private String specialRequests;
    private String paymentStatus;

    public ReservationDTO() {
    }

    public ReservationDTO(Long reservationID, String userEmail, BigDecimal rating, Long tableNumber, LocalDateTime reservationDateTime, LocalDateTime checkInTime, Restaurant restaurant, int partySize, String status, String specialRequests, String paymentStatus) {
        this.reservationID = reservationID;
        this.userEmail = userEmail;
        this.rating = rating;
        this.tableNumber = tableNumber;
        this.reservationDateTime = reservationDateTime;
        this.checkInTime = checkInTime;
        this.restaurant = restaurant;
        this.partySize = partySize;
        this.status = status;
        this.specialRequests = specialRequests;
        this.paymentStatus = paymentStatus;
    }

    public ReservationDTO(Reservation reservation) {
        this.reservationID = reservation.getReservationID();
        this.userEmail = reservation.getUser().getEmail();
        this.rating = reservation.getRestaurant().getRating();
        this.tableNumber = reservation.getTable().getId();
        this.reservationDateTime = reservation.getReservationDateTime();
        this.checkInTime = reservation.getCheckInTime();
        this.restaurant = reservation.getRestaurant();
        this.partySize = reservation.getPartySize();
        this.status = reservation.getStatus();
        this.specialRequests = reservation.getSpecialRequests();
        this.paymentStatus = reservation.getPaymentStatus();
    }

    public Long getReservationID() {
        return reservationID;
    }

    public void setReservationID(Long reservationID) {
        this.reservationID = reservationID;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public BigDecimal getRating() {
        return rating;
    }

    public void setRating(BigDecimal rating) {
        this.rating = rating;
    }

    public Long getTableNumber() {
        return tableNumber;
    }

    public void setTableNumber(Long tableNumber) {
        this.tableNumber = tableNumber;
    }

    public LocalDateTime getReservationDateTime() {
        return reservationDateTime;
    }

    public void setReservationDateTime(LocalDateTime reservationDateTime) {
        this.reservationDateTime = reservationDateTime;
    }

    public LocalDateTime getCheckInTime() {
        return checkInTime;
    }

    public void setCheckInTime(LocalDateTime checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Restaurant getRestaurant() {
        return restaurant;
    }

    public void setRestaurant(Restaurant restaurant) {
        this.restaurant = restaurant;
    }

    public int getPartySize() {
        return partySize;
    }

    public void setPartySize(int partySize) {
        this.partySize = partySize;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSpecialRequests() {
        return specialRequests;
    }

    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public String getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }
}
