package com.example.rezevirajmasa.demo.repository;

import com.example.rezevirajmasa.demo.model.*;
import org.springframework.data.jpa.repository.JpaRepository;

import java.time.LocalDateTime;
import java.util.List;

public interface ReservationRepository extends JpaRepository<Reservation, Long> {
    List<Reservation> findALlByUserAndCheckInTimeAfter(User user, LocalDateTime now);
    List<Reservation> findByTableAndCheckInTimeBetween(TableEntity table, LocalDateTime startTime, LocalDateTime endTime);

    List<Reservation> findByTable(TableEntity tableEntity);
    List<Reservation> findAllByCheckInTimeBefore(LocalDateTime currentTime);
    List<Reservation> findByCheckInTimeAfterAndCheckInTimeBefore(LocalDateTime startTime, LocalDateTime endTime);
    List<Reservation> findALlByUserAndCheckInTimeBefore(User user, LocalDateTime now);
    List<Reservation> findAllByUser(User user);

    List<Reservation> findAllByUserAndCheckInTimeAfter(User user, LocalDateTime now);

    List<Reservation> findAllByUserAndCheckInTimeBefore(User user, LocalDateTime now);
    List<Reservation> findAllByTableAndCheckInTime(TableEntity table, LocalDateTime now);
    List<Reservation> findAllByRestaurantAndCheckInTimeAfter(Restaurant restaurant, LocalDateTime now);
}
