package com.example.rezevirajmasa.demo.service;

import com.example.rezevirajmasa.demo.dto.RestaurantDTO;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.model.TableEntity;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public interface RestaurantService {
    List<RestaurantDTO> listall();
    List<Restaurant> listAll();
    //    void save(String name, String cuisineType, String address, String phone, String operatingHours, String website, String socialMediaLinks, BigDecimal rating, List<Long> tablesList);
//    void save(String name, String cuisineType, String address, String phone, String operatingHours, String website, String socialMediaLinks, BigDecimal rating, int numberOfTables, int tableCapacity, String location, Boolean isSmokingArea, String description);
    void save(Restaurant restaurant, int numberOfTables, List<Integer> tableCapacities, List<String> tableLocations, List<String> tableSmokingAreas, List<String> tableDescriptions);
    Restaurant updateRestaurant(Long restaurantId, String name, String cuisineType, String address, String phone, String operatingHours, String website, String socialMediaLinks, BigDecimal rating, List<Long> tablesList);
    Restaurant deleteRestaurant(Long restaurantId);
    RestaurantDTO findById(Long restaurantId);
    Restaurant findByIdRestaurant(Long restaurantId);
    List<Restaurant> listRestaurantBy(String search);
    List<Restaurant> getRestaurantsWithAvailableTimeSlotsForToday();
    public List<Restaurant> findRestaurantsByDateTimeAndPartySize(LocalDateTime dateTime, int partySize, String search);
//    public List<Restaurant> findRestaurantsBySearchParams(LocalDateTime dateTime, int partySize, String search);
    public List<String> findALlCuisineTypes();
    List<RestaurantDTO> findRestaurantsByCuisineType(String param);
    public List<RestaurantDTO> findRestaurantsBySearchParams(LocalDateTime dateTime, int partySize, String search);
}
