package com.example.rezevirajmasa.demo.service.impl;

import com.example.rezevirajmasa.demo.model.Menu;
import com.example.rezevirajmasa.demo.model.Restaurant;
import com.example.rezevirajmasa.demo.repository.MenuRepository;
import com.example.rezevirajmasa.demo.service.MenuService;
import com.example.rezevirajmasa.demo.service.RestaurantService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class MenuServiceImpl implements MenuService {
    private final MenuRepository menuRepository;
    private final RestaurantService restaurantService;

    public MenuServiceImpl(MenuRepository menuRepository, RestaurantService restaurantService) {
        this.menuRepository = menuRepository;
        this.restaurantService = restaurantService;
    }

    @Override
    public List<Menu> getMenuByRestaurantId(Long restaurantId) {
        Restaurant restaurant = restaurantService.findByIdRestaurant(restaurantId);
        return menuRepository.findAllByRestaurant(restaurant);
    }
}
