package com.example.rezevirajmasa.demo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.Data;

import java.math.BigDecimal;

@Entity
@Table(name = "menus")
@Data
public class Menu {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "MenuID")
    private Long menuID;

    @ManyToOne
    @JoinColumn(name = "RestaurantID", nullable = false)
    @JsonIgnore
    private Restaurant restaurant;

    @Column(name = "ItemName", length = 100)
    private String itemName;

    @Column(name = "Category", length = 50)
    private String category;

    @Column(name = "Price", precision = 8, scale = 2)
    private BigDecimal price;

    @Column(name = "Description")
    private String description;

    @Column(name = "DietaryInformation", columnDefinition = "JSONB")
    private String dietaryInformation;

    public Menu() {
    }

    public Menu(Restaurant restaurant, String itemName, String category, BigDecimal price, String description, String dietaryInformation) {
        this.restaurant = restaurant;
        this.itemName = itemName;
        this.category = category;
        this.price = price;
        this.description = description;
        this.dietaryInformation = dietaryInformation;
    }
}