package com.example.rezevirajmasa.demo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

@Entity
@Table(name = "reservation_preordered_items")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class PreorderedItem {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long preorderedItemId;

    private String preorderedItemName;

    private Integer quantity;

    @Column(name = "price_at_order", precision = 8, scale = 2, nullable = false)
    private BigDecimal price;

    @JsonIgnore
    @ManyToOne
    @JoinColumn(name = "reservation_id", nullable = false)
    private Reservation reservation;

    @ManyToOne
    @JoinColumn(name = "menu_id", nullable = false)
    private Menu menu;
}
